model Ex2_23
parameter Real[4] P(unit="torr")={228,250,273,318} "Total pressure";
parameter Real[4] t(unit="sec")={200,400,600,1000} "Time";
parameter Real R(unit="(lit.atm)/(mol.K)")=0.08206 "Gas constant";
parameter Real T(unit="K")=1129 "Temperature";
parameter Real P0(unit="torr")=206 "Initial Pressure";
Real [4] k(unit="torr/sec") "Rate constant";
Real K(unit="mol/(lit*sec)") "Rate constant";
Real Kdash(unit="mol/(lit*sec)") "Rate constant";
equation
for i in 1:4 loop
  k[i]=(P[i]-  P0)/(t[i]);
  //The constancy of K indicates it is zero order reaction//
end for;
K=(k[1]+k[2]+k[3]+k[4])/4;
Kdash=((K/760)/(R*T));
end Ex2_23;
