model Ex2_33
parameter Real Ca01(unit="g/lit")=5 "Initial concentration";
parameter Real Cb0(unit="mol/lit")=0.10 "Initial concentration of B";
parameter Real MW(unit="g/gmol")=88 "Molecular weight of ethyl acetate";
parameter Real R(unit="cal/mol.K")=1.987 "Gas constant";
parameter Real T1(unit="K")=273 "Temperature 1";
parameter Real T2(unit="K")=293 "Temperature 2";
parameter Real k1(unit="lit/mol.min")=0.235 "Rate constant at 273K";
parameter Real k2(unit="lit/mol.min")=0.924 "Rate constant at 293K";
parameter Real XA(unit="No units")=0.95 "%percentage conversion (Saponification)";
parameter Real T3(unit="K")=313 "Temperature 3";
Real E(unit="cal/mol") "Activation energy";
Real k3(unit="lit/mol.min") "Rate constant at 313K";
Real Ca0(unit="g/lit") "Initial concentration of A";
Real M(unit="No units") "Concentration Ratio";
Real t(unit="min") "Time required to complete the reaction";
equation
E=log(k2/k1)*R/((1/T1)-(1/T2));
k3=k2*exp((E/R)*((1/T2)-(1/T3)));
Ca0=Ca01/MW;
M=Cb0/Ca0;
//For second order irreversible reaction//
t=log((M-XA)/((1-XA)*M))/(Ca0*k3*(M-1));
end Ex2_33;
