model Ex2_44
parameter Real Ca0(unit="mol/lit")=0.50 "Initial concentration of A";
parameter Real Cr0(unit="mol/lit")=0 "Initial concentration of R";
parameter Real t(unit="min")=8 "Time";
parameter Real XA(unit="No units")=0.333 "Conversion";
parameter Real XAE(unit="No units")=0.667 "Equilibrium conversion";
Real M(unit="No units") "Concentration ratio";
Real k1(unit="min^-1") "Rate constant";
Real k2(unit="min^-1") "Rate constant";
equation
M=Cr0/Ca0;
-log(1-(XA/XAE))=((M+1)/(M+XAE))*k1*t;
//Kc=k1/k2//
k1/k2=(M+XAE)/(1-XAE);
//Rate=k1*Ca-k2*Cr//
end Ex2_44;
