model Ex2_57
parameter Real Ca(unit="mol/lit")=1.6 "Final concentration";
parameter Real Ca0(unit="mol/lit")=1 "Initial concentration";
parameter Real V(unit="lit")=1.5 "Final volume";
parameter Real V0(unit="lit")=1 "Initial volume";
parameter Real t(unit="min")=4 "Time";
Real Fractionalchange(unit="No units") "Fractional change in volume with pure A";
Real MolesR(unit="mol") "Moles of R formed";
Real MolesA(unit="mol") "Moles of A formed";
Real XA(unit="No unit") "Conversion";
Real k(unit="min^-1") "Rate constant";
 equation
 MolesA=Ca0;
 MolesR=(Ca/Ca0)*Ca0;
Fractionalchange=(MolesR-MolesA)/(MolesA);
//For first order raection//
//Final volume 1.5 times the initial volume//
XA=((V-V0)/V0)*(1/Fractionalchange);
k=-(log(1-XA))/t;
end Ex2_57;
