model Ex2_65
parameter Real[3]t(unit="min")={2,4,8} "Time";
parameter Real[3]P(unit="mmHg")={208,215,226} "pressure";
parameter Real P0(unit="mmHg")=200 "Initial pressure";
parameter Real Molpercent(unit="No units")=40 "Reaction mixture contains 40%A";
parameter Real a(unit="No units")=1 "Stiochiometric coefficient of A";
parameter Real delN(unit="No units")=1 "No of moles of product-No of moles of Reactant";
Real pA0(unit="mmHg") "Initial partial pressure";
Real pA1(unit="mmHg") "Partial pressure";
Real[3]pA(unit="mmHg") "Partial pressure";
Real[3]k(unit="min^-1") "Rate constant";
Real K(unit="min^-1") "Average Rate constant";
Real rate(unit="mol/(lit*min)")"Rate equation";
equation
pA0=(((Molpercent)/100)*P0);
pA1=P0+pA0-P0;
for i in 1:3 loop
pA[i]=P0+pA0-P[i];
//Rate equation for first order reaction//
k[i]=log(pA0/pA[i])/t[i];
end for;
K=sum(k)/3;
//Rate equation is given by K*Ca// 
rate=K;
end Ex2_65;
