model Ex3_16
parameter Real P(unit="Atm")=5 "Pressure";
parameter Real P0(unit="Atm")=25 "Pressure for corrected stoichiometry";
parameter Real T(unit="K")=623 "Temperature";
parameter Real R(unit="m^3.atm/(Kmol.K)")=0.08206 "Gas constant";
parameter Real v(unit="m^3/hr")=4 "Volumetric flow rate";
parameter Real v1(unit="m^3/hr")=320 "Volumetric flow rate for commercial reactor";
parameter Real N(unit="moles")=1 "No of moles of reactant";
parameter Real N0(unit="moles")=3 "No of moles of product";
parameter Real N1(unit="moles")=100 "No of moles of reactant for corrected Stoichiometry";
parameter Real N01(unit="moles")=200 "No of moles of product for corrected Stoichiometry";
parameter Real XA(unit="No units")=0.60 "Conversion";
parameter Real XA1(unit="No units")=0.80 "Conversion";
parameter Real D(unit="m")=0.025 "Diameter of the pipe";
parameter Real L(unit="m")=2 "Length of the pipe";
parameter Real xa(unit="No units")=0.5 "Mole fraction of A";
Real V(unit="m^3") "Volume of cylinder";
Real V1(unit="m^3") "Volume of commercial reactor";
Real EA(unit="No units") "Fractional conversion";
Real EA1(unit="No units") "Fractional conversion for corrected stoichiometry";
Real Caktow(unit="No units") "Concentration";
Real Caktow1(unit="No units") "Concentration for corrected stoichiometry";
Real Ca0(unit="kmol/m^3") "Concentration of A";
Real Ca01(unit="kmol/m^3") "Concentration of A for corrected stoichiometry";
Real pa0(unit="atm") "Pressure of commercial reactor";
Real Tow(unit="hr^-1") "Space time";
Real Tow1(unit="hr^-1") "Space time for commercial reactor";
Real k(unit="m^3/(kmol.hr)") "Rate constant";
Real Noofpipes(unit="No of pipes") "No of pipes needed";
equation
EA=(N0-N)/N;
//For plug flow reactor following second order kinetics//
Caktow=(2)*EA*(1+EA)*log(1-XA)+(EA)^(2)*(XA)+((EA+1))^(2)*(XA/(1-XA));
//For ideal gas//
Ca0=P/(R*T);
//Volume of the cylinder//
V=(2*asin(1.0)/4)*D^(2)*L;
Tow=V/v;
k=Caktow/(Ca0*Tow);
//Commercial reactor//
EA1=(N01-N1)/N1;
Caktow1=(2)*EA1*(1+EA1)*log(1-XA1)+(EA1)^(2)*(XA1)+((EA1+1))^(2)*(XA1/(1-XA1));
pa0=xa*P0;
Ca01=pa0/(R*T);
Tow1=Caktow1/(Ca01*k);
V1=Tow1*v1;
Noofpipes=V1/V;
end Ex3_16;
