model Ex3_2
parameter Real Ca0(unit="mol/lit")=100 "Initial Concentration of A";
parameter Real Cb0(unit="mol/lit")=200 "Initial Concentration of B";
parameter Real a(unit="No units")=300 "Moles at no conversion";
parameter Real b(unit="No units")=300 "Moles at complete conversion";
parameter Real XA(unit="No units")=0.80 "Conversion";
parameter Real EB(unit="No units")=0 "Fractional conversion of B";
Real EA(unit="No units") "Fractional conversion";
Real CA(unit="mol/lit") "Concentration of A";
Real XB(unit="No units") "Conversion of B";
Real CB(unit="mol/lit") "Concentration of B";
equation
EA=(b-a)/b;
CA=Ca0*(1-XA);
XB=(Ca0*XA)/Cb0;
CB=Cb0*(1-XB);
end Ex3_2;
