model Ex3_20
parameter Real[15] t(unit="min")={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14} "Time";
parameter Real[15] Volumeratio(unit="No unit")={1,1.2,1.35,1.48,1.58,1.66,1.72,1.78,1.82,1.86,1.88,1.91,1.92,1.94,1.95} "Time constant";
parameter Real P(unit="atm")=10 "Pressure";
parameter Real T(unit="K")=373 "Temperature";
parameter Real xa(unit="No units")=0.6 "Mole fraction of A in the stream";
parameter Real R(unit="m^3.atm/(Kmol.K)")=0.08206 "Gas constant";
parameter Real N(unit="moles")=100 "No of moles of reactant";
parameter Real N0(unit="moles")=160 "No of moles of product";
parameter Real XA(unit="No units")=0.90 "Conversion";
parameter Real v(unit="mol/sec")=10 "Feed flow rate";
Real pa0(unit="atm") "Initial partial pressure";
Real Ca0(unit="mol/lit") "Concentration of A";
Real EA(unit="No units") "Fractional conversion";
Real tow1(unit="min") " Space time at 90%conversion";
Real delT(unit="sec") "Time difference";
Real delP(unit="atm") "Pressure difference";
Real tow2(unit="sec") "Space time 2";
Real Fa0(unit="mol/hr") "Molar flow rate";
Real V(unit="m^3") "Volume of reactor";
equation
pa0=xa*P;
Ca0=pa0/(R*T);
EA=(N0-N)/N;
//For variable volume constant pressure system//
tow1=1+(EA*XA);
//Since the values of tow1 is 1.54 the values lies between 3 and 4 mins//
delT=t[5]-t[4];
delP=Volumeratio[5]-Volumeratio[4];
tow2=(t[4]+((delT/delP)*(tow1-Volumeratio[4])))*60;
//The feed contains 60% of A(mole%)//
Fa0=xa*v;
//Volume of plug flow reactor//
V=((Fa0*tow2)/(Ca0))/1000;
end Ex3_20;
