model Ex3_46
parameter Real k(unit="hr^(-1)")=10"Rate constant";
//Basis 300 moles//
parameter Real b(unit="mol")=450 "Moles of product";
parameter Real a(unit="mol")=300 "Moles of Reactant";
//Calculatiosn based on the stiochiometry//
parameter Real xa(unit="No units")=0.667 "Mole fraction of A";
parameter Real P0(unit="atm")=11.4 "Initial Pressure";
parameter Real T(unit="K")=923 "Temperature";
parameter Real R(unit="atm.lit/mol.K")=0.08206 "Rate constant";
parameter Real XA(unit="No units")=0.75 "Conversion";
parameter Real Fa0(unit="mol/hr")=10 "Molar flow rate";
Real EA(unit="No units") "Fractional Conversion";
Real V(unit="lit") "Volume of reactor";
Real Ca0(unit="mol/lit") "Initial concentration of A";
equation
EA=(b-a)/a;
Ca0=(P0*xa)/(R*T);
V=(Fa0/(k*Ca0))*(-((1+EA)*log(1-XA))-(EA*XA));
end Ex3_46;
