model Ex4_6
parameter Real V(unit="lit")=40000 "Volume of each mixed flow reactor in series";
parameter Real v0(unit="lit/hr")=100 "Volumetric flow rate";
parameter Real thalf(unit="hr")=20 "Half life for reaction";
//Assume C0 to be 1//
parameter Real C0(unit="mol/lit")=1 "Initial concentration";
Real C2(unit="mol/lit") "Concentration of the fluid in second reactor";
Real k(unit="hr^-1") "Rate constant";
Real tow(unit="hr") "Space time";
Real XA(unit="No units") "Conversion";
equation
k=0.693/(thalf);
tow=V/v0;
//tow=tow1=tow2//
C2=C0/(1+(k*tow))^(2);
XA=C0-C2/(C0);
//XA is the decay in activity//
end Ex4_6;
