model Ex1_12
parameter Real T1(unit="K")=400 "Temperature 1";
parameter Real T2(unit="K")=500 "Temperature 2";
parameter Real R(unit="cal/molK")=1.987 "Gas constant";
parameter Real E(unit="cal/mol")=9150 "Activation energy";
Real Rk(unit="No units") "Ratio of k2 and k1";
//k2 is rate constant at T2 and k1 is rare constant at T1//
equation
log(Rk)=(E/R)*((1/T1)-(1/T2));
//Thus we can say the rate is Rk times faster at T2 than at T1//
end Ex1_12;
