model Ex1_13
parameter Real T1(unit="K")=400 "Temperature 1";
parameter Real T2(unit="K")=500 "Temperature 2";
parameter Real T3(unit="K")=600 "Temperature 3";
parameter Real R(unit="cal/molK")=1.987 "Gas constant";
parameter Real r2(unit="mol/litHr")=10 "rate of reaction at 500K";
Real E(unit="Cal/mol") "Activation energy";
Real E1(unit="Cal/mol") "Activation energy";
Real r3(unit="mol/Lit hr")"Rate of reaction at T3 by Arrhenius theory";
Real r31(unit="mol/Lit hr")"Rate of reaction at T3 by Collision Theory";
Real Percentage(unit="No unit")"Percentage difference between Arrehenius and collision theory";
//Given rate of reaction at 500K is 10 times greater than that at 400K(i.e)=r2=10r1//
//By arrhenius theory//
//General equation ln(r2/r1)=(E/R)*(1/T1-1/T2)//
equation
log(r2)=(E/R)*((1/T1)-(1/T2));
//When reaction condition changes (i.e)T3=600 K//
//By arrhenius theory//
//Assume r2=1//
r3=exp((E/R)*((1/T2)-(1/T3)));
//By collision theory//
//General equation ln(r2/r1)=(E/R)*(1/T1-1/T2)+ln(T2^(0.5)/T1^(0.5))//
log(r2)=(E1/R)*((1/T1)-(1/T2))+log(T2^(0.5)/T1^(0.5));
//When reaction condition changes (i.e)T3=600 K//
//By arrhenius theory//
//Assume r2=1//
//r3=exp((E/R)*((1/T2)-(1/T3)-(log(T2^(0.5)/T1^(0.5)));
log(r31)=((E/R)*((1/T2)-(1/T3)))+log((T2^(0.5)/T1^(0.5)));
Percentage=((r31-r3)/(r31))*100;
//The answer given in the book in wrong//
end Ex1_13;
