model Ex1_18
parameter Real T1(unit="K")=288 "Temperature 1";
parameter Real T2(unit="K")=298 "Temperature 2";
parameter Real R(unit="cal/molK")=1.987 "Gas constant";
parameter Real r2(unit="cal/mol.K")=2 "Rate of reaction at Temperature 2";
Real E(unit="cal/mol") "Activation Energy";
//Rate of reaction 2 proceeds 2 times faster than rate of reaction 1//
equation
E=log(r2)*R/((1/T1)-(1/T2));
end Ex1_18;
