model Ex1_24
parameter Real k(unit="s^-1")=1.3*10^(-3) "Rate constant";
parameter Real T(unit="K")=300 "Temperature";
parameter Real E(unit="cal/mol")=12817 "Activation energy";
parameter Real R(unit="cal/mol.K")=1.987 "Gas constant";
Real k0(unit="s^-1") "Pre-exponential factor";
//General equation is given by Arrhenius relation//
equation
k0=exp(log(k)+(E/(R*T)));
end Ex1_24;
