model Ex1_6
parameter Real k(unit="(atm/hr)^-1")=3.66 "Rate constant";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Gas constant";
parameter Real T(unit="K")=400 "Temperature";
Real k1(unit="lit/mol.hr") "Rate constant for case 2";
Real k2(unit="m^3/mol.sec") "Rate constant for case 3";
//Case 1 involves determination of units for proposed rate constant";
//Case 2 (-ra)=((-1)/V)*dNa/dt=k*CA^(2)//
//Case 3 (-ra)=k*CA^(2)//
equation
k1=(R*T*k);
k2=((k1)*10^(-3))/3600;
//The value is slightly different due to round off error//
end Ex1_6;
