model Ex2_11
parameter Real[4] t(unit="sec")={1000,2000,3000,4000} "Time";
parameter Real[4] pa(unit="Torr")={572,399,278,194} "Partial pressure";
parameter Real pa0(unit="Torr")=820 "Initial partial pressure";
Real [4]k(unit="sec^-1") "Rate constant";
Real K(unit="sec^-1") "Average Rate constant";
equation
for i in 1:4 loop
  k[i]=(1/t[i])*log(pa0/pa[i]);
end for;
K=sum(k)/4;
end Ex2_11;
