model Ex2_24
parameter Real[3] Ca0(unit="mol/lit")={0.3,0.5,0.9} "Initial concentration of A";
parameter Real t(unit="min")=40 "Time";
Real k1(unit="min^-1") "Rate constant";
Real k2(unit="min^-1") "Rate constant";
Real k3(unit="min^-1") "Rate constant";
Real K(unit="min^-1") "Rate constant";
Real XA1(unit="No unit") "A reacted when Ca0=0.3";
Real XA2(unit="No unit") "A reacted when Ca0=0.5";
Real XA3(unit="No unit") "A reacted when Ca0=0.9";
Real Ca1(unit="mol/lit") "Final concentration of A when Initial Concentration is 0.3";
Real Ca2(unit="mol/lit") "Final concentration of A when Initial Concentration is 0.5";
Real Ca3(unit="mol/lit") "Final concentration of A when Initial Concentration is 0.9";
Real Rate(unit="mol/(lit.min)") "Rate equation";
//When Ca0=0.3//
equation
XA1=Ca0[1]*Ca0[1];
Ca1=Ca0[1]-XA1;
k1=1/t*log(Ca0[1]/Ca1);
//When Ca0=0.5//
XA2=Ca0[1]*Ca0[2];
Ca2=Ca0[2]-XA2;
k2=1/t*log(Ca0[2]/Ca2);
//When Ca0=0.9//
XA3=Ca0[1]*Ca0[3];
Ca3=Ca0[3]-XA3;
k3=1/t*log(Ca0[3]/Ca3);
//Since k values are constant the reaction is 1st order//
K=(k1+k2+k3)/3;
Rate=K;
//The rate is given by rate=k*Ca;//
end Ex2_24;
