model Ex2_28
parameter Real[2] Ca(unit="mol/lit")={3.23,1.96} "Concentrations of A";
parameter Real[2] t(unit="min")={20,50} "Time";
parameter Real Ca0(unit="mol/lit")=5.72 " Initial concentration of A";
Real [2]k(unit="min^-1") "Rate constant of 1st order reaction";
Real [2]K(unit="lit/(min.mol)") "Rate constant of 2st order reaction";
//Assume 1st order reaction//
equation
for i in 1:2 loop
  k[i]=(1/t[i])*log(Ca0/Ca[i]);
  //Since the value of k varies the reaction does not follow first order//
end for;
//Assume 2nd order reaction//
for i in 1:2 loop
K[i]=1/t[i]*((1/Ca[i])-(1/Ca0)); 
end for;
//From the values of K it is clear that the reaction follows second order//
end Ex2_28;
