model Ex2_45
parameter Real T(unit="K")=893 "Temperature";
parameter Real P0(unit="Atm")=1 "Pressure";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Gas constant";
parameter Real XA(unit="No units")=0.077 "Conversion";
parameter Real XA1(unit="No units")=0.8526 "Conversion with inerts";
parameter Real XA2(unit="No units")=0.029 "Conversion per second";
Real Ca0(unit="mol/lit") "Initial Concentration of A";
Real Ca1(unit="mol/lit") "Concentration of A";
Real Ca02(unit="mol/lit") "Concentration of A";
Real Ca2(unit="mol/lit") "Concentration of A with inerts";
Real rate1(unit="mol/lit.sec") "Rate of disappearance of pure A";
Real rate2(unit="mol/lit.sec") "Rateof disappearance with inerts";
Real n(unit="No units") "Order of the reaction";
Real k(unit="(mol/lit)^0.55/sec") "Rate constant";
Real rate(unit="Mol/lit.sec") "Rate equation";
equation
Ca0=(P0)/(R*T);
Ca1=Ca0*(1-XA);
Ca02=(P0*(1-XA1))/(R*T);
//Rate of disappearance of A//
rate1=Ca0*XA;
rate2=Ca02*XA2;
Ca2=Ca02*(1-XA2);
(rate1/rate2)=(Ca1/Ca2)^n;
//Order of reaction is 1.5//
rate1=(k*Ca1)^n;
rate=k;
//Final rate is given by rate=k*Ca^1.55//
//The final answer is different due to round off error//
end Ex2_45;
