model Ex2_46
//A gives R and S//
parameter Real Cr0(unit="mol/lit")=0 "Concentration of R";
parameter Real Cs0(unit="mol/lit")=55 "Concentration of S";
parameter Real[4] t(unit="min")={36,65,100,160} "Time";
parameter Real[4] Ca(unit="mol/lit")={0.1453,0.1216,0.1025,0.0795} "Concentration";
parameter Real Cae(unit="mol/lit")=0.0494 "Equilibrium concentration";
parameter Real Ca0(unit="mol/lit")=0.1823 "Initial concentration";
Real [4]k1(unit="min^-1") "Rate constant 1";
Real K(unit="min^-1") "Average Rate constant";
Real k2(unit="min^-1") "Rate constant 2";
Real M(unit="No units") "Concentration ratio";
Real XAE(unit="No units") "Equilibrium conversion";
equation
M=Cr0/Ca0;
XAE=(Ca0-Cae)/Ca0;
for i in 1:4 loop
  -log((Ca[i]-Cae)/(Ca0-Cae))=((M+1)/(M+XAE))*k1[i]*t[i];
end for;
K=sum(k1)/4;
//Since the values of k are almost constant the reaction follows first order//
(K/k2)=(M+XAE)/(1-XAE);
//rate is given by rate=k1*CA-k2*CR//
end Ex2_46;
