model Ex2_51
parameter Real t(unit="hr")=390 "Time";
parameter Real rate(unit="mol/lit.hr")=2.2*10^(-3) "Rate equation";
parameter Real Pa0(unit="atm")=1 "Initial pressure";
parameter Real a(unit="No units")=1 "Stiochiometric coefficient of N2O5";
parameter Real b(unit="No units")=0.5 "Stiochiometric coefficient of O2";
parameter Real c(unit="No units")=1 "Stiochiometric coefficient of N2O4";
parameter Real kp(unit="mmHg")=45 "Equilibrium pressure";
Real Pa(unit="atm") "Pressure";
Real XA(unit="No units") "Conversion";
Real Reactant(unit="mol") "N2O5 reacted";
Real Unreacted(unit="mol") "N2O5 unreacted";
Real Product1(unit="mol") "02 produced";
Real Product2(unit="mol") "N2O4 produced";
Real Kp(unit="atm") " Equilibrium Pressure";
Real x(unit="moles") "Moles of N2O4 converted to No2";
Real P(unit="atm") "Total pressure";
Real M1(unit="mol") "Moles of N2O4";
Real M2(unit="mol") "Moles of NO2";
Real M(unit="mol") "Total moles";
Real pa1(unit="mmHg") "Partial pressure of N205";
Real pa2(unit="mmHg") "Partial pressure of O2";
Real pa3(unit="mmHg") "Partial pressure of NO2";
Real pa4(unit="mmHg") "Partial pressure of N204";
equation
//N2O5 gives 0.5 O2 and N2O4//
log(Pa0/Pa)=rate*t;
XA=(Pa0-Pa)/(Pa0);
Reactant=a*XA;
Unreacted=(1-XA);
Product1=b*XA;
Product2=c*XA;
//Total moles=Unreacted+(Reacted-x)+2x+Product1//
//N2O4 decomposes to 2NO2//
Kp=kp/760;
4*x^(2)+(Kp*x)-0.03456=0;
P=1.288+x;
M1=XA-x;
M2=2*x;
M=1.288+x;
pa1=((Unreacted)/(P))*(760*P);
pa2=(Product1)/(P)*(760*P);
pa3=(M2)/(P)*(760*P);
pa4=(M1)/(P)*(760*P);
//The values slightly differ due to round off error//
end Ex2_51;
