model Ex2_60
//Basis 100 moles of reactant//
parameter Real Pr(unit="mol")=220 "Moles at complete conversion";
parameter Real R(unit="mol")=100 "Moles at no conversion";
parameter Real t(unit="min")=20 "Time";
parameter Real V0(unit="ml")=0.6 "Given volume decreases by 60%";
parameter Real P(unit="atm")=8 "Pressure";
parameter Real P0(unit="atm")=5 "Initial pressure";
parameter Real Pai(unit="atm")=2 "Initial partial pressure of inerts";
parameter Real a(unit="Moles")=1 "Stiochiometric coeffecient of A";
parameter Real b(unit="Moles")=2.5 "Stiochiometric coeffecient of R";
Real t1(unit="min") " Reaction Time";
Real EA(unit="No units") "Fractional conversion";
Real k(unit="min^-1") "Rate constant";
Real pa0(unit="atm") "Initial Partial pressure";
Real pa(unit="atm") "Partial pressure";
Real delN(unit="No units") "Stiochiometric coefficient";
equation
EA=(Pr-R)/R;
-log(1-(V0/EA))=k*t;
pa0=P0-Pai;
delN=b-a;
pa=pa0-(a/delN)*(P-P0);
//For first order reaction//
log(pa0/pa)=k*t1;
//The answer differs due to round off error//
end Ex2_60;
