model Ex2_61
parameter Real t(unit="min")=3 "Time";
parameter Real P0(unit="atm")=1 "Initial Pressure";
parameter Real a(unit="Moles")=2 "Stiochiometric coeffecient of A";
parameter Real b(unit="Moles")=3 "Stiochiometric coeffecient of R and 2S";
parameter Real k(unit="min^-1")=1.333 "Rate constant/R*T";
//Assume V0//
parameter Real V0(unit="ml")= 1"Initial volume";
Real P(unit="atm") "Pressure";
Real delN(unit="No units") "Stiochiometric coefficient";
Real pA(unit="atm") "Partial pressure";
Real XA(unit="No units") "Conversion";
Real EA(unit="No units") "Fractional conversion";
Real t1(unit="min") "Time needed for completion of reaction";
Real EV(unit="No units") "Fractional change in volume";
Real V(unit="ml")"Volume";
equation
P=1.4*P0;
delN=b-a;
pA=P0-(a/delN)*(P-P0);
pA=P0*(1-XA);
//For reactiom 2A gives R+2S//
EA=(b-a)/(a);
((P0+EA)/(P0-XA))*XA+EA*log(1-XA)=k*t1;
V=V0*(1+EA*XA);
EV=(V-V0)/(V0);
end Ex2_61;
