model Ex2_62
parameter Real[8]t(unit="min")={0.5,1,1.5,2,3,4,6,10} "Time";
parameter Real[8]L(unit="cm")={6.1,6.8,7.2,7.5,7.85,8.1,8.4,8.7} "Length of capillary occupied by the reaction mixture";
parameter Real a(unit="Moles")=1 "Stiochiometric coeffecient of A";
parameter Real b(unit="Moles")=2 "Stiochiometric coeffecient of R and S";
parameter Real Linfinity(unit="cm")=9.4 "Length at infinite time";
parameter Real P(unit="atm")=1.316 "Pressure";
parameter Real T(unit="K")=373 "Temperature";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Rate constant";
Real EA(unit="No units") "Fractional conversion";
Real L0(unit="cm") "Initial length";
Real [8]XA(unit="No units") "Conversion";
Real Ca0(unit="mol/lit") "Concentration";
Real [8]k(unit="lit/mol.min") "Rate constant";
Real K(unit="lit/mol.min") " Average Rate constant";
equation
EA=(b-a)/a;
EA=(Linfinity-L0)/L0;
for i in 1:8 loop
  XA[i]=(L[i]-L0)/L0;
end for;
Ca0=(P)/(R*T);
for i in 1:8 loop
  k[i]=((2*XA[i])/(1-XA[i])+log(1-XA[i]))/(Ca0*t[i]);
end for;
K=sum(k)/8;
//Rate equation=K*Ca^2//
//the value differs due to round off error//
end Ex2_62;
