model Ex2_64
parameter Real[5] t(unit="min")={2.5,5,10,15,20} "Time";
parameter Real[5] P(unit="mmHg")={10.5,12.5,15.8,17.9,19.4} "Total pressure";
parameter Real b(unit="moles")=3 "Stiochiometric coefficient of products";
parameter Real a(unit="moles")=1 "Stiochiometric coefficient of reactants";
parameter Real P0(unit="mmHg")=7.5 "Initial pressure";
Real[5]k(unit="min^_1") "Rate constant";
Real K(unit="min^-1") "Average rate constant";
Real delN(unit="mol") "Stiochiometric difference";
equation
//By substituting the values we arrive at the final equation given by//
delN=b-a;
for i in 1:5 loop
  k[i]=(1/t[i])*log((2*P0)/((3*P0)-P[i]));
end for;
K=sum(k)/5;
//Rate equation=K*Ca//
end Ex2_64;
