model Ex2_66
parameter Real[4] t(unit="sec")={390,777,1195,3355} "Time";
parameter Real[4] Rp(unit="mmHg")={96,176,250,476} "Rise in pressure";
parameter Real P0(unit="mmHg")=312 "Initial pressure";
parameter Real b(unit="moles")=3 "Stiochiometric coefficient of products";
parameter Real a(unit="moles")=1 "Stiochiometric coefficient of reactants";
Real P[4](unit="mmHg") "Pressure";
Real delN(unit="mol") "Stiochiometric difference";
Real pa[4](unit="mmHg") "Partial pressure";
Real [4]k(unit="sec^-1") "Rate constant";
Real K(unit="min^-1") "Average rate constant";
equation
delN=b-a;
for i in 1:4 loop
  P[i]=P0+Rp[i];
  pa[i]=1.5*P0-0.5*P[i];
  k[i]=(1/t[i])*log(P0/pa[i]);
end for;
K =sum(k)/4;
//Rate=K*Ca//
//The final answer differs from the value in book due to round off error//
end Ex2_66;
