model Ex2_68
parameter Real Ca0(unit="mol/lit")=1.25 "Initial concentration of A";
parameter Real k1(unit="min^-1")=0.17 "Rate constant for A gives R";
parameter Real k2(unit="min^-1")=0.11 "Rate constant for R gives S";
Real t(unit="min") "Time at which the maximum concentration occurs";
Real CRMax(unit="mol/lit") "Maximum concentration of R";
equation
t=log(k1/k2)/(k1-k2);
CRMax=((k1/k2)^(k2/(k2-k1)))*Ca0;
end Ex2_68;
