model Ex2_69
parameter Real[3] t(unit="min")={0.187,0.45,0.60} "Time";
parameter Real[3] X(unit="No units")={0.18,0.34,0.40}"Fraction of A converted";
parameter Real Ca0(unit="mol/lit")=0.052 "Initial concentration";
parameter Real K(unit="No units")=1.45 "Equilibrium constant";
Real Cae(unit="mol/lit") "Equilibrium concentration";
Real XAe(unit="No units") "Equilibrium conversion";
Real[3]k(unit="lit/mol.hr") "Rate constant";
Real k1(unit="lit/mol.hr") "Average Rate constant";
Real k2(unit="lit/mol.hr") "Rate constant 2";
equation
(0.45*Cae^(2)+(0.104*Cae)-2.714*10^(-3))=0;
XAe=(Ca0-Cae)/(Ca0);
for i in 1:3 loop
  log((XAe-(2*XAe-1)*X[i])/(XAe-X[i]))=(2*k[i]*((1/XAe)-1)*Ca0*t[i]);
end for;
k1=sum(k)/3;
K=k1/k2;
//Rate is given by k1*CA*CB-k2*CR*CS//
//The value changes due to round off error//
end Ex2_69;
