model Ex3_1
parameter Real Ca0(unit="mol/lit")=100 "Initial concentration of A";
parameter Real Cb0(unit="mol/lit")=200 "Initial concentration of B";
parameter Real Ci0(unit="mol/lit")=100 "Initial concentration of I";
parameter Real a(unit="No units")=1 "Stoichiometric coefficient of A";
parameter Real b(unit="No units")=3 "Stoichiometric coefficient of B";
parameter Real Ca(unit="mol/lit")=40 "Concentration of A";
Real V0(unit="lit") "Volume of the system when XA=0";
Real V(unit="lit") "Volume of the system when XA=1";
Real EA(unit="No units") "Fractional change in volume wrt A";
Real EB(unit="No units") "Fractional change in volume wrt B";
Real XA(unit="No units") "Conversion";
Real XB(unit="No units") "Conversion";
Real Cb(unit="mol/lit") "Concentration of B";
equation
V0=Ca0+Cb0+Ci0;
V=-Ca0+(3*Cb0)+Ci0;
EA=((V-V0)/V0);
EB=(a*EA*Cb0)/(b*Ca0);
XA=(1-Ca/Ca0)/(1+EA*(Ca/Ca0));
XB=(b*Ca0*XA)/(a*Cb0);
Cb=Cb0*((1-XB))/(1+EB*XB);
end Ex3_1;
