model Ex3_11
parameter Real N(unit="moles")=1 "No of moles of reactant";
parameter Real N0(unit="moles")=1 "No of moles of product";
parameter Real N1(unit="moles")=1 "No of moles of reactant for corrected Stoichiometry";
parameter Real N01(unit="moles")=3 "No of moles of product for corrected Stoichiometry";
parameter Real V(unit="Lit")=32 "Volume of the reactor";
parameter Real XA(unit="No units")=0.99 "Conversion";
Real EA(unit="No units") "Fractional conversion";
Real EA1(unit="No units") "Fractional conversion for corrected Stoichiometry";
Real K(unit="No units") "Rate by Volumetric flow rate";
Real V1(unit="Lit") "Volume of the reactor for corrected Stoichiometry";
//Where K=k/v0//
equation
EA=(N0-N)/N;
K=(1/V)*log(1/(1-XA));
//For corrected stoichiometry//
EA1=(N01-N1)/N1;
V1=(log(1/(1-XA))+EA1*((log(1/(1-XA))-XA)))/K;
end Ex3_11;
