model Ex3_18
parameter Real [11]t(unit="sec")={0,20,40,60,80,100,140,200,260,330,420} "Time";
parameter Real[11]pA(unit="atm")={1,0.80,0.68,0.56,0.45,0.37,0.25,0.14,0.08,0.04,0.02} "Pressure";
parameter Real V(unit="lit")=208 "Volume of mixed flow reactor";
parameter Real T(unit="K")=373 "Temperature";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Gas constant";
parameter Real Fa0(unit="mol/hr")=100 "Molar flow rate";
parameter Real xa(unit="No units")=0.8 "Mole fraction of A";
Real tow(unit="sec") "Space time";
Real XA(unit="No units") "Conversion";
Real pa(unit="atm") "Partial pressure at tow sec";
Real delT(unit="sec") "Time difference";
Real delp(unit="atm") "Pressure difference";
Real pa0(unit="atm") "Initial partial pressure";
Real Ca0(unit="mol/lit") "Initial concentration";
equation
pa0=xa*pA[1];
Ca0=pa0/(R*T);
tow=(V*Ca0)/(Fa0/3600);
//Since the value of tow is 195.44 the conversion lies between 0.25atm and 0.14 atm//
delT=t[8]-t[7];
delp=pA[7]-pA[8];
pa=pA[7]-((delp/delT)*(tow-t[7]));
//For EA=0 we have Ca=Ca0*(1-XA)//
XA=(1-(pa/pA[2]))*100;
end Ex3_18;
