model Ex3_31
//Basis 100 moles of feed stream//
parameter Real N(unit="moles")=100 "No of moles of reactant";
parameter Real N0(unit="moles")=200"No of moles of product";
parameter Real T(unit="K")=791 "Temperature";
parameter Real T0(unit="K")=273 "Temperature at normal conditions";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Gas constant";
parameter Real P0(unit="atm")=1 "Pressure";
parameter Real k(unit="lit/(mol.sec)")=0.33 "Rate constant";
parameter Real XA(unit="No units")=0.35 "Conversion of A";
parameter Real v(unit="hr^-1")=8 "Space velocity";
Real EA(unit="No units") "Fractional change in volume";
Real tp(unit="sec") "Residence time";
Real tow(unit="sec") "Space time";
Real v1(unit="hr") "Space velocity";
equation
EA=(N0-N)/N;
tp=((R*T)/(k*P0))*((2/(1-XA))+log(1-XA)-2);
//Space velocity at 273 K is 8 hr^-1//
//Reactor is at 791K and 1 atm//
v1=v*(T/T0);
tow=(1/v1)*3600;
//The difference in space velocity and space time is due to the increase in number of moles as a result of reaction//
end Ex3_31;
