model Ex3_43
parameter Real k(unit="lit/mol.min")=200 "Rate constant";
parameter Real XA(unit="No units")=0.99 "Conversion";
parameter Real Ca0(unit="mol/lit")=0.10 "Initial concentration of A";
parameter Real Cb0(unit="mol/lit")=0.2 "Initial concentration of B";
parameter Real v0(unit="lit/min")=400 "Volumetric flow rate";
Real M(unit="No units") "Concentration ratio";
Real V(unit="lit") "Volume";
equation
M=Cb0/Ca0;
V=(Ca0*v0*XA)/(k*(Ca0)^(2)*(1-XA)*(M-XA));
end Ex3_43;
