model Ex4_10
parameter Real Ca0(unit="moles/lit")=0.6 "Initial concentration of A";
parameter Real Ca(unit="moles/lit")=0.10 "Concentration of A";
parameter Real V(unit="cm^(3)")=400"Volume of reactor";
parameter Real v0(unit="cm^(3)/min")=10 "Volumetric flow rate";
parameter Real v01(unit="cm^(3)/min")=50 "Volumetric flow rate";
Real tow(unit="min") "Space time";
Real k(unit="lit/mol.min") "k*(0.1)^(n)";
Real C1(unit="mol/lit") "Concentration 1";
Real n(unit="No units") "Order of reaction";
Real k1(unit="lit/mol.min") "Rate constant";
equation
//Case 1//
(V/v0)/(Ca0-Ca)=(1/k);
//Case 2//
(V/v01)=(C1-Ca)/(k);
((Ca0-C1)/(C1^(n)))=((C1-Ca)/(Ca^(n)));
tow=(V/v01);
k1=(Ca0-C1)/(tow*C1^(n));
//Rate is given by ra=k*Ca^(2)//
end Ex4_10;
