model Ex4_24
parameter Real k(unit="lit/mol.min")=500 "Rate constant";
parameter Real V(unit="lit")=0.1 "Volume of reactor";
parameter Real Ca0(unit="mol/lit")=0.01 "Initial concentration of A";
parameter Real v0(unit="lit/min")=0.05 "Volumteric flow rate";
Real XA(unit="No units") "Conversion";
Real V1(unit="lit") "Volume of stirred tank reactor";
Real XA1(unit="lit") "Conversion of mixed flow reactor";
equation
XA/(1-XA)=(k*Ca0*(V))/v0;
V1=(XA*v0)/(k*Ca0*(1-XA)^(2));
(XA1/(1-XA1)^(2))=(V/v0)*(k*Ca0);
end Ex4_24;
