model Ex6_6
parameter Real delG(unit="kcal/mol")=-2030 "Gibbs free energy";
parameter Real H20(unit="cal/mol")=-57798 "Heat of reaction for H20";
parameter Real C2H5OH(unit="cal/mol")=-56240 "Heat of reaction for C2H5OH";
parameter Real C2H4(unit="cal/mol")=12496 "Heat of reaction for C2H4";
parameter Real R1(unit="cal/mol.K")=1.987 "Gas constant";
parameter Real T(unit="K")=298 "Temperature";
parameter Real T1(unit="K")=600 "Temperature1";
parameter Real p(unit="No units")=1 "Stiochiometric coefficient";
parameter Real a(unit="No units")=1 "Stiochiometric coefficient";
parameter Real b(unit="No units")=1 "Stiochiometric coefficient";
Real delH(unit="cal/mol") "Heat of reaction";
Real k1(unit="sec^-1") "Rate constant";
Real k2(unit="sec^-1") "Rate constant";
equation
delH=(p*C2H5OH)-((a*C2H4)+(b*H20));
log(k1)=-((delG)/(R1*T));
log(k2/k1)=-((delH)/R1)*((1/T1)-(1/T));
end Ex6_6;
