model Ex1_10
parameter Real Ca(unit="mol/l")=0.05 "Concentration of A";
parameter Real Ca0(unit="mol/l")=0.10 "Initial Concentration of A";
parameter Real t(unit="hr")=2 "Time taken for completion of reaction";
parameter Real t0(unit="hr")=0 "Time at the starting of the reaction";
parameter Real Cb(unit="mol/l")=0.075 "Concentration of A";
parameter Real Cb0(unit="mol/l")=0.10 "Initial Concentration of A";
Real Rate1(unit="mol/lit.hr") "Reaction rate 1";
Real Rate2(unit="mol/lit.hr") "Reaction rate 2";
Real RateR(unit="mol/lit.hr") "Rate of formation of R";
Real RateS(unit="mol/lit.hr") "Rate of formation of S";
//For reaction A gives R
equation
Rate1=-((Ca-Ca0)/(t-t0));
//For reaction B gives S
Rate2=-((Cb-Cb0)/(t-t0));
//As reaction 1 proceeds at a faster rate than rate 2, A gives R proceeds at a faster rate//
RateR=(Ca/t);
RateS=(RateR/t);
end Ex1_10;
