model Ex1_14
parameter Real T1(unit="K")=283 "Temperature 1";
parameter Real T2(unit="K")=303 "Temperature 2";
parameter Real k1(unit="s^-1")=1.6*10^(-3) "Rate constant at Temperature 1";
parameter Real k2(unit="s^-1")=1.625*10^(-2) "Rate constant at Temperature 2";
parameter Real R(unit="cal/molK")=1.987 "Gas constant";
Real E(unit="Cal/mol") "Activation energy";
equation
//General equation is given by Arrhenius relation at two different temperatures//
E=log(k2/k1)*R/((1/T1)-(1/T2));
//The model gives accurate results and hence differs from the book value//
end Ex1_14;
