model Ex1_17
parameter Real T1(unit="K")=400 "Temperature 1";
parameter Real T2(unit="K")=500 "Temperature 2";
parameter Real R(unit="cal/molK")=1.987 "Gas constant";
parameter Real Rk(unit="No units")=10 "Ratio of k2 and k1";
//k2 is rate constant at T2 and k1 is rare constant at T1//
Real E(unit="cal/mol") "Activation Energy";
equation
log(Rk)=(E/R)*((1/T1)-(1/T2));
end Ex1_17;
