model Ex1_20
parameter Real T1(unit="K")=773 "Temperature 1";
parameter Real T2(unit="K")=923 "Temperature 2";
parameter Real R(unit="J/molK")=8.314 "Gas constant";
parameter Real E(unit="J/mol")=300*10^(3) "Activation energy";
Real k2(unit="s^-1") "Rate constant 2";
//Assume rate constant k1=1//
//General equation is given by Arrhenius equation//
equation
k2=exp((E/R)*(1/(T1)-1/(T2)));
//The decomposition at T2 proceeds k2 times faster than that at T1//
//The model gives accurate results and hence differs from textbook value//
end Ex1_20;
