model Ex2_13
parameter Real r[4](unit="mol/lit.min")={4.6*10^(-4),9.2*10^(-4),9.2*10^(-6),3.68*10^(-5)}"Rate of reaction";
parameter Real Ca[4](unit="mol/lit")={1,1,0.02,0.04}"Concentration of Reactant A";
parameter Real Cb[4](unit="mol/lit")={0.02,0.04,1,1} "Concentration of Reactant B";
Real nb(unit="No units") "order of the Reaction when the rate depends on B only";
Real na(unit="No units") "order of the Reaction when the rate depends on A only";
Real n(unit="No units") "Overall order";
Real [4]k(unit="(mol/lit)^-2*min^-1") "Rate constant";
Real Truek(unit="(mol/lit)^-2*min^-1") "Rate constant";
equation
//When concentration of A is larger then the rate depends on B//
nb=log(r[1]/r[2])/log(Cb[1]/Cb[2]);
//When concentration of B is larger then the rate depends on A//
na=log(r[3]/r[4])/log(Ca[3]/Ca[4]);
//Overall order of the reaction//
n=na+nb;
//Rate of reaction=k*Ca^2*Cb//
for i in 1:4 loop
  k[i]=r[i]/(Ca[i]^2*Cb[i]);
end for;
Truek=(k[1]+k[2]+k[3]+k[4])/4;
end Ex2_13;
