model Ex2_19
parameter Real thalf1(unit="sec")=420 "Half life period1";
parameter Real thalf2(unit="sec")=275 "Half life period2";
parameter Real Ca0(unit="mol/lit")=0.405 "Initial concentration of A";
parameter Real Ca01(unit="mol/lit")=0.64 "Initial concentration of A(1)";
Real n(unit="No units") "Order of reaction";
Real k(unit="lit/(mol*min)") "Rate constant";
//General equation is given by n=1+log(thalf1/thalf2)/log(Ca0/Ca01)//
equation
n=1+(log(thalf1/thalf2)/log(Ca01/Ca0));
k=1/(thalf1*Ca0);
end Ex2_19;
