model Ex2_29
parameter Real [4]Ca0(unit="mol/lit")={5,10,15,20} "Concentration of A";
parameter Real [4]thalf(unit="hr")={40,20.1,13.3,10} "Half life period";
Real[4] m(unit="mol.hr/lit") "Second order constant";
Real[3] n(unit="No units") "Order of the reaction";
equation
for i in 1:4 loop
  m[i]=thalf[i]*Ca0[i];
  //Since the values of m are fairly constant the reaction is second order//
end for;
for i in 1:3 loop
  n[i]=1+(log(thalf[i]/thalf[i+1])/log(Ca0[i+1]/Ca0[i]));
end for;
//Thus the order of the reaction is two//
end Ex2_29;
