model Ex2_35
parameter Real [4]t(unit="sec")={390,777,1195,3155} "Time";
parameter Real [4]P(unit="mmHg")={408,488,562,779} "Pressure";
parameter Real P0(unit="mmHg")=312 "Initial pressure";
Real[4]k(unit="sec^-1") "Rate costant";
Real K(unit="sec^-1") "Average rate constant";
equation
//Refer the derivation in book//
for i in 1:4 loop
  k[i]=(1/t[i])*log(P0/((1.5*P0)-(0.5*P[i])));
end for;
//Since the values are fairly constant the reaction is first order//
K=sum(k)/4;
//The values differ slightly due to round off error//
end Ex2_35;
