model Ex2_40
parameter Real XA(unit="No units")=0.20 "Conversion";
parameter Real t(unit="min")=34 "Time";
parameter Real Ca01(unit="mol/lit")=0.04 "Initial concentration 1";
parameter Real Ca02(unit="mol/lit")=0.8 "Initial concentration 2";
Real Ca1(unit="mol/lit") "Final concentration 1";
Real Ca2(unit="mol/lit") "Final concentration 2";
Real k(unit="min^-1") "Rate constant";
Real k1(unit="min^-1") "Rate constant1";
Real Rate(unit="mol/(lit.min)") "Rate equation";
equation
Ca1=Ca01*(1-XA);
//Case 1//
log(Ca01/Ca1)=k*t;
//Case 2//
Ca2=Ca02*(1-XA);
log(Ca02/Ca2)=k1*t;
//Since the value of k remains constant it follows first order//
Rate=k;
//Rate=k*Ca//
end Ex2_40;
