model Ex2_49
parameter Real[12]t(unit="min")={1,2,3,4,5,6,7,8,9,10,15,20} "Time";
parameter Real[12]P(unit="atm")={1.14,1.04,0.982,0.940,0.905,0.870,0.850,0.832,0.815,0.800,0.754,0.728} "Pressure";
//reaction 2A gives R//
parameter Real T1(unit="K")=298 "Temperature 1";
parameter Real T2(unit="K")=373 "Temperature 2";
parameter Real P0(unit="atm")=1 "Pressure 1";
parameter Real R(unit="lit.atm/mol.K")=0.08206 "Gas constant";
parameter Real a(unit="no units")=2 "Stiochiometric coefficient of A";
parameter Real r(unit="no units")=1 "Stiochiometric coefficient of R";
Real Ca0(unit="Mol/lit") "Initial concentration of A";
Real delN(unit="No units") "Stiochiometric difference";
Real P1(unit="Atm") "Pressure 2";
Real [12]Pa(unit="atm") "Pressure";
Real [12]Ca(unit="mol/lit") "Concentration";
Real [12]k(unit="min^-1") "Rate constant for first order reaction";
Real [12]k1(unit="mol/lit.min") "Rate constant for second order reaction";
Real K(unit="mol/lit.min") "Average rate constant";
Real rate(unit="mol/lit.min") "rate equation";
equation
P1=(T2/T1)*P0;
delN=r-a;
Ca0=(P1)/(R*T2);
for i in 1:12 loop
  Pa[i]=2*P[i]-P1;
Ca[i]=(Pa[i])/(R*T2);
k[i]=log(Ca0/Ca[i])/t[i];
end for;
//Since the values of k differs, the reaction doesnt follow first order//
for i in 1:12 loop
  k1[i]=((1/Ca[i])-(1/Ca0))/t[i];
end for;
//The values of K1 remains fairly constant, hence the reaction follows second order//
K=sum(k1)/12;
rate=K;
//Rate is given by K*Ca^2//
//The answer in the textbook differs due to round off error//
end Ex2_49;
