model Ex2_6
parameter Real t1(unit="min")=0,t2(unit="min")=10,t3(unit="min")=20,t4(unit="min")=30,t5(unit="min")=40  "Time";
parameter Real Ca0(unit="ml")= 25,Ca1(unit="ml")=20,Ca2(unit="ml")=15.7,Ca3(unit="ml")=12.5,Ca4(unit="ml")=9.6 "N";
//Where N is mlof KMno4 required to decompose a definite volume of H2O2//
//for first order reaction time required for decomposition//
Real k(unit="min^(-1)"),k1(unit="min^(-1)"),k2(unit="min^(-1)"),k3(unit="min^(-1)"),averagek(unit="min^(-1)") "Rate constant";
equation
k=(1/t2)*log(Ca0/Ca1);
k1=(1/t3)*log(Ca0/Ca2);
k2=(1/t4)*log(Ca0/Ca3);
k3=(1/t5)*log(Ca0/Ca4);
averagek=((k+k1+k2+k3)/4);
//Since the values of k are nearly constant the reaction is first order//
end Ex2_6;
