model Ex2_9
parameter Real k(unit="l/mol.min")=6.5 "Rate constant for second order reaction";
parameter Real t(unit="min")=10 "Time taken for completion of reaction";
parameter Real Ca0(unit="mol/lit")=3*10^(-2) "Initial concentration";
Real Ca(unit="mol/lit") "Final concentration";
Real XA(unit="no unit") "Proportion of Ester hydrolysed";
//General equation is given by k=1/t*(1/Ca)-(1/Ca0)
equation
Ca=1/((k*t)+(1/Ca0));
XA=((Ca0-Ca)/(Ca0))*100;
end Ex2_9;
