model Ex3_17
parameter Real [11]t(unit="sec")={0,20,40,60,80,100,140,200,260,330,420} "Time";
parameter Real[11]pA(unit="atm")={1,0.80,0.68,0.56,0.45,0.37,0.25,0.14,0.08,0.04,0.02} "Pressure";
parameter Real N(unit="moles")=100 "No of moles of reactant";
parameter Real N0(unit="moles")=300 "No of moles of product";
parameter Real xa(unit="No units")=0.8 "Mole fraction of A";
parameter Real T(unit="K")=373 "Temperature";
parameter Real R(unit="lit.atm/(mol.K)")=0.08206 "Gas constant";
parameter Real XA(unit="No units")=0.95 "Conversion";
parameter Real Fa0(unit="mol/hr")=100 "Molar flow rate";
Real EA(unit="No units") "Fractional conversion";
Real pa0(unit="atm") "Initial Partial pressure of A";
Real pa(unit="atm")"Final partial pressure of A";
Real tbatch(unit="sec") "Time required for conversion in batch reactor";
Real Ca0(unit="kmol/m^3") "Concentration of A";
Real Fa(unit="mol/sec") "Molar flow rate";
Real V(unit="lit") "Volume of reactor";
equation
EA=(N0-N)/N;
pa0=xa*pA[1];
pa=pa0*(1-XA);
//Time required for change in partial pressure of A form 0.8 to pa//
tbatch=t[10]-t[2];
//For EA=0 and constant density systems tbatch is equal to tplug//
Ca0=pa0/(R*T);
Fa=Fa0/3600;
V=(tbatch*Fa)/Ca0;
end Ex3_17;
