model Ex3_24
parameter Real b(unit="moles")=3 "Stiochiometric coefficient of products";
parameter Real a(unit="moles")=1 "Stiochiometric coefficient of reactants";
parameter Real V(unit="m^(-3)")=1.75 "Initial volume";
parameter Real t(unit="min")=15 "Time";
Real Ea(unit="No units") "Fractional conversion";
Real delV(unit="m^(-3)") "Change in volume";
Real k(unit="min^(-1") "Rate constant";
Real t1(unit="min") "Time for constant volume batch reactor";
equation
//Variable volume reactor//
Ea=(b-a)/a;
delV=V-1;
-log(1-((delV)/Ea))=k*t;
//Constant volume batch reactor//
//By suitable derivation//
log(4/3)=k*t1;
end Ex3_24;
